<?php
// Conexão com o banco
$db_host = 'localhost';
$db_name = 'nome_do_banco';
$db_user = 'usuario';
$db_pass = 'senha';

try {
    $pdo = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8", $db_user, $db_pass);
} catch (PDOException $e) {
    die("Erro ao conectar ao banco: " . $e->getMessage());
}

// Domínio atual
$dominioAtual = $_SERVER['HTTP_HOST'];

// Buscar cliente
$stmt = $pdo->prepare("SELECT * FROM clientes WHERE dominio = ?");
$stmt->execute([$dominioAtual]);
$cliente = $stmt->fetch(PDO::FETCH_ASSOC);

// Verifica se cliente está bloqueado ou vencido
$hoje = date('Y-m-d');
$estaVencido = isset($cliente['vencimento']) && $cliente['vencimento'] < $hoje;
$estaBloqueado = isset($cliente['status']) && $cliente['status'] === 'bloqueado';

if (!$cliente || $estaBloqueado || $estaVencido) {
    $preco = number_format($cliente['preco'] ?? 0, 2, ',', '.');

    echo <<<HTML
    <!DOCTYPE html>
    <html lang="pt-br">
    <head>
        <meta charset="UTF-8">
        <title>Acesso Bloqueado</title>
        <style>
            body {
                background: #000;
                color: #fff;
                font-family: sans-serif;
                display: flex;
                justify-content: center;
                align-items: center;
                height: 100vh;
                margin: 0;
            }
            .box {
                background: #111;
                padding: 40px;
                border-radius: 12px;
                box-shadow: 0 0 20px red;
                text-align: center;
                max-width: 400px;
                width: 90%;
            }
            .box h1 {
                color: #f00;
                font-size: 28px;
                margin-bottom: 20px;
            }
            .box p {
                margin: 10px 0;
                font-size: 16px;
                line-height: 1.4;
            }
            .btn {
                margin-top: 20px;
                padding: 10px 25px;
                background: red;
                border: none;
                color: #fff;
                font-size: 16px;
                border-radius: 8px;
                cursor: pointer;
            }
        </style>
    </head>
    <body>
        <div class="box">
            <h1>🔒 Acesso Bloqueado</h1>
            <p>Este sistema está <strong>bloqueado</strong> por falta de pagamento ou vencimento da licença.</p>
            <p>Valor a ser pago: <strong>R$ {$preco}</strong></p>
            <p>Clique abaixo para realizar o pagamento e liberar o acesso.</p>
            <button class="btn">Pagar Agora</button>
        </div>
    </body>
    </html>
    HTML;

    exit;
}
?>
